/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.data.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.logging.LogUtils;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import com.redpxnda.respawnobelisks.registry.item.CoreItem;
import com.redpxnda.respawnobelisks.util.CoreUtils;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.slf4j.Logger;

public class CoreUpgradeRecipe
extends ShapedRecipe {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ShapedRecipe compose;
    private final double charge;

    public CoreUpgradeRecipe(ShapedRecipe compose, double charge) {
        super(compose.m_6423_(), compose.m_6076_(), compose.m_44220_(), compose.m_44221_(), compose.m_7527_(), compose.m_8043_());
        this.compose = compose;
        this.charge = charge;
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public double getCharge() {
        return this.charge;
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        ItemStack result = CoreUpgradeRecipe.getCore(inv).orElse(super.m_5874_(inv)).m_41777_();
        result.m_41764_(1);
        CoreUtils.incMaxCharge(result.m_41784_(), this.charge);
        return result;
    }

    private static Optional<ItemStack> getCore(CraftingContainer inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!(stack.m_41720_() instanceof CoreItem)) continue;
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistries.CORE_UPGRADE_SERIALIZER.get();
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        public CoreUpgradeRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            double charge = 100.0;
            if (jsonObject.has("charge")) {
                JsonPrimitive prim;
                JsonElement jsonElement = jsonObject.get("charge");
                if (jsonElement instanceof JsonPrimitive && (prim = (JsonPrimitive)jsonElement).isNumber()) {
                    charge = prim.getAsDouble();
                } else {
                    LOGGER.warn("(Respawn Obelisks) Recipe Json at '" + resourceLocation + "' has invalid 'charge' section.");
                }
            }
            return new CoreUpgradeRecipe(super.m_6729_(resourceLocation, jsonObject), charge);
        }

        public CoreUpgradeRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buf) {
            return new CoreUpgradeRecipe(super.m_8005_(resourceLocation, buf), buf.readDouble());
        }

        public void m_6178_(FriendlyByteBuf buf, ShapedRecipe shapedRecipe) {
            super.m_6178_(buf, shapedRecipe);
            if (shapedRecipe instanceof CoreUpgradeRecipe) {
                CoreUpgradeRecipe recipe = (CoreUpgradeRecipe)shapedRecipe;
                buf.writeDouble(recipe.charge);
            } else {
                buf.writeDouble(100.0);
            }
        }
    }
}

